#include "ttl_io_form.h"
#include "ui_ttl_io_form.h"

#include "public_parameter.h"


// ------------ constructor & destructor ---------------
TTL_IO_Form::TTL_IO_Form(QWidget *parent, Qt::WindowFlags fl ):
    QWidget(parent, fl),
    ui(new Ui::TTL_IO_Form)
{
    ui->setupUi(this);
    int index = 0;

    QCheckBox *temp_Port0_checkBox[8] = { this->ui->Port00_checkBox, this->ui->Port01_checkBox, this->ui->Port02_checkBox, this->ui->Port03_checkBox,
                                         this->ui->Port04_checkBox, this->ui->Port05_checkBox, this->ui->Port06_checkBox, this->ui->Port07_checkBox,};
    QCheckBox *temp_Port1_checkBox[8] = { this->ui->Port10_checkBox, this->ui->Port11_checkBox, this->ui->Port12_checkBox, this->ui->Port13_checkBox,
                                          this->ui->Port14_checkBox, this->ui->Port15_checkBox, this->ui->Port16_checkBox, this->ui->Port17_checkBox,};
    QComboBox *temp_Debounce_comboBox[2] = { this->ui->Debounce0_comboBox, this->ui->Debounce1_comboBox };
    QComboBox *temp_IOConfig_comboBox[2] = { this->ui->IOConfig0_comboBox, this->ui->IOConfig1_comboBox };

    for ( index = 0; index < MAX_PORT_NUM; index++  )
    {
        this->Port0_checkBox[index] = temp_Port0_checkBox[index];
        this->Port1_checkBox[index] = temp_Port1_checkBox[index];
    }
    for ( index = 0; index < 2; index++  )
    {
        this->Debounce_comboBox[index] = temp_Debounce_comboBox[index];
        this->IOConfig_comboBox[index] = temp_IOConfig_comboBox[index];
    }
}

TTL_IO_Form::~TTL_IO_Form()
{
    delete ui;
}


// ------------ event ---------------
void TTL_IO_Form::showEvent(QShowEvent *)
{
    qWarning("showEvent");
    if ( false == this->is_fomr_started )
    {
        this->ttl_io_config_read();
        this->ttl_io_point_read();

        this->ttl_io_timer = startTimer(100);
        this->is_fomr_started = true;
    }
}

void TTL_IO_Form::timerEvent ( QTimerEvent *event )
{
    // qWarning("timer");
    this->ttl_io_point_read();
}
void TTL_IO_Form::closeEvent ( QCloseEvent *event )
{
    // qWarning("closeEvent");

    killTimer( this->ttl_io_timer );
    this->ttl_io_timer = 0;
    this->is_fomr_started = false;
    event->accept();
}




// ------------ sub-function ---------------
void TTL_IO_Form::ttl_io_config_read()
{
    u8 data = 0;
    int index = 0;

    for ( index = 0; index < 2; index++  )
    {
        Status = EX94421A_TTL_IO_config_read( CardID, index, &data );
        this->IOConfig_comboBox[index]->setCurrentIndex(data);
        this->ttl_io_rename(index, data);

        qWarning("ttl_io_config_read = %d",index);
        Status = EX94421A_TTL_IO_debounce_time_read( CardID, index, &data );
        this->Debounce_comboBox[index]->setCurrentIndex(data);        
    }
}

void TTL_IO_Form::ttl_io_point_read()
{
    u8 data = 0;

    int port = 0, point = 0;


    port = 0;
    for ( point = 0; point < 8; point++  )
    {
        Status = EX94421A_TTL_IO_point_read( CardID, port, point, &data );
        if ( ACTIVE == data )
        {
            this->Port0_checkBox[point]->setChecked(true);
        }
        else
        {
            this->Port0_checkBox[point]->setChecked(false);
        }
    }

    port = 1;
    for ( point = 0; point < 8; point++  )
    {
        Status = EX94421A_TTL_IO_point_read( CardID, port, point, &data );
        if ( ACTIVE == data/*((data >> point) & 1)*/ )
        {
            this->Port1_checkBox[point]->setChecked(true);
        }
        else
        {
            this->Port1_checkBox[point]->setChecked(false);
        }
    }
}

void TTL_IO_Form::ttl_io_rename(int port, int index)
{
    int point = 0;

    if ( 0 == index )   // set input
    {
        for ( point = 0; point < 8; point++  )
        {
            if ( 0 == port)
            {
                this->Port0_checkBox[point]->setText("INPUT0 " + QString::number(point, 10));
            }
            else
            {
                this->Port1_checkBox[point]->setText("INPUT1 " + QString::number(point, 10));
            }
        }
    }
    else if ( 1 == index )  // set output
    {
        for ( point = 0; point < 8; point++  )
        {
            if ( 0 == port)
            {
                this->Port0_checkBox[point]->setText("OUTPUT0 " + QString::number(point, 10));
            }
            else
            {
                this->Port1_checkBox[point]->setText("OUTPUT1 " + QString::number(point, 10));
            }
        }
    }
}







// ------------ slot ---------------
void TTL_IO_Form::on_Debounce0_comboBox_currentIndexChanged(int index)
{
    int port = 0;
    qWarning("on_Debounce0_comboBox_currentIndexChanged = %d",index);
    Status = EX94421A_TTL_IO_debounce_time_set( CardID, port, index );
}

void TTL_IO_Form::on_Debounce1_comboBox_currentIndexChanged(int index)
{
    int port = 1;
    qWarning(" 1 index = %d",index);
    Status = EX94421A_TTL_IO_debounce_time_set( CardID, port, index );
}

void TTL_IO_Form::on_IOConfig0_comboBox_currentIndexChanged(int index)
{
    int port = 0;
    Status = EX94421A_TTL_IO_config_set( CardID, port, index );
    this->ttl_io_rename(port, index);
}

void TTL_IO_Form::on_IOConfig1_comboBox_currentIndexChanged(int index)
{
    int port = 1;
    Status = EX94421A_TTL_IO_config_set( CardID, port, index );
    this->ttl_io_rename(port, index);
}

/*
void TTL_IO_Form::ttl_io_set_slot()
{
    qWarning("ttl_io_set_slot");
    int point = 0;

    for ( point = 0; point < 8; point++  )
    {
        if ( true == this->Port0_checkBox[point]->isChecked() )
        {
            Status = EX94421A_TTL_IO_point_set( CardID, 0,point, ACTIVE );
                qWarning("1");
        }
        else
        {
            Status = EX94421A_TTL_IO_point_set( CardID, 0,point, INACTIVE );
            qWarning("2");
        }

        if ( true == this->Port1_checkBox[point]->isChecked() )
        {
            Status = EX94421A_TTL_IO_point_set( CardID, 1, point, ACTIVE );
            qWarning("3");
        }
        else
        {
            Status = EX94421A_TTL_IO_point_set( CardID, 1, point, INACTIVE );
            qWarning("4");
        }
    }

}
*/

void TTL_IO_Form::on_Port00_checkBox_clicked(bool checked)
{
    u8 port = 0 ;
    u8 point = 0 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port01_checkBox_clicked(bool checked)
{
    u8 port = 0 ;
    u8 point = 1 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port02_checkBox_clicked(bool checked)
{
    u8 port = 0 ;
    u8 point = 2 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port03_checkBox_clicked(bool checked)
{
    u8 port = 0 ;
    u8 point = 3 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port04_checkBox_clicked(bool checked)
{

    u8 port = 0 ;
    u8 point = 4 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port05_checkBox_clicked(bool checked)
{

    u8 port = 0 ;
    u8 point = 5 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port06_checkBox_clicked(bool checked)
{
    u8 port = 0 ;
    u8 point = 6 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port07_checkBox_clicked(bool checked)
{
    u8 port = 0 ;
    u8 point = 7 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}


void TTL_IO_Form::on_Port10_checkBox_clicked(bool checked)
{
    u8 port = 1 ;
    u8 point = 0 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port11_checkBox_clicked(bool checked)
{
    u8 port = 1 ;
    u8 point = 1 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port12_checkBox_clicked(bool checked)
{
    u8 port = 1 ;
    u8 point = 2 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port13_checkBox_clicked(bool checked)
{
    u8 port = 1 ;
    u8 point = 3 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port14_checkBox_clicked(bool checked)
{
    u8 port = 1 ;
    u8 point = 4 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port15_checkBox_clicked(bool checked)
{
    u8 port = 1 ;
    u8 point = 5 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port16_checkBox_clicked(bool checked)
{
    u8 port = 1 ;
    u8 point = 6 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}

void TTL_IO_Form::on_Port17_checkBox_clicked(bool checked)
{
    u8 port = 1 ;
    u8 point = 7 ;
    if(ACTIVE==checked)
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, ACTIVE );
    }
    else
    {
        Status = EX94421A_TTL_IO_point_set( CardID, port, point, INACTIVE );
    }
}


